/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataIndexDef;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.TableName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

public class DataIndexSetDef {
    private TableName table_name;
    private ArrayList index_list;
    private boolean immutable;

    public DataIndexSetDef(TableName table_name) {
        this.table_name = table_name;
        this.index_list = new ArrayList();
        this.immutable = false;
    }

    public DataIndexSetDef(DataIndexSetDef def) {
        this.table_name = def.table_name;
        this.index_list = new ArrayList();
        for (int i = 0; i < def.indexCount(); ++i) {
            this.index_list.add(new DataIndexDef(def.indexAt(i)));
        }
        this.immutable = false;
    }

    public void setImmutable() {
        this.immutable = true;
    }

    public void addDataIndexDef(DataIndexDef def) {
        if (this.immutable) {
            throw new RuntimeException("Tried to add index to immutable def.");
        }
        this.index_list.add(def);
    }

    public void removeDataIndexDef(int i) {
        if (this.immutable) {
            throw new RuntimeException("Tried to add index to immutable def.");
        }
        this.index_list.remove(i);
    }

    public int indexCount() {
        return this.index_list.size();
    }

    public DataIndexDef indexAt(int i) {
        return (DataIndexDef)this.index_list.get(i);
    }

    public int findIndexWithName(String index_name) {
        int sz = this.indexCount();
        for (int i = 0; i < sz; ++i) {
            if (!this.indexAt(i).getName().equals(index_name)) continue;
            return i;
        }
        return -1;
    }

    public int findIndexForColumns(String[] cols) {
        int sz = this.indexCount();
        for (int i = 0; i < sz; ++i) {
            String[] t_cols = this.indexAt(i).getColumnNames();
            if (t_cols.length != cols.length) continue;
            boolean passed = true;
            for (int n = 0; n < t_cols.length && passed; ++n) {
                if (t_cols[n].equals(cols[n])) continue;
                passed = false;
            }
            if (!passed) continue;
            return i;
        }
        return -1;
    }

    public DataIndexDef indexWithName(String index_name) {
        int i = this.findIndexWithName(index_name);
        if (i != -1) {
            return this.indexAt(i);
        }
        return null;
    }

    public String resolveIndexName(String index_name, boolean ignore_case) throws DatabaseException {
        int sz = this.indexCount();
        String found = null;
        for (int i = 0; i < sz; ++i) {
            String cur_index_name = this.indexAt(i).getName();
            boolean passed = ignore_case ? cur_index_name.equalsIgnoreCase(index_name) : cur_index_name.equals(index_name);
            if (!passed) continue;
            if (found != null) {
                throw new DatabaseException("Ambigious index name '" + index_name + "'");
            }
            found = cur_index_name;
        }
        if (found == null) {
            throw new DatabaseException("Index '" + index_name + "' not found.");
        }
        return found;
    }

    public void write(DataOutput dout) throws IOException {
        dout.writeInt(1);
        dout.writeUTF(this.table_name.getSchema());
        dout.writeUTF(this.table_name.getName());
        dout.writeInt(this.index_list.size());
        for (int i = 0; i < this.index_list.size(); ++i) {
            ((DataIndexDef)this.index_list.get(i)).write(dout);
        }
    }

    public static DataIndexSetDef read(DataInput din) throws IOException {
        int version = din.readInt();
        if (version != 1) {
            throw new IOException("Don't understand version.");
        }
        String schema = din.readUTF();
        String name = din.readUTF();
        int sz = din.readInt();
        DataIndexSetDef index_set = new DataIndexSetDef(new TableName(schema, name));
        for (int i = 0; i < sz; ++i) {
            index_set.addDataIndexDef(DataIndexDef.read(din));
        }
        return index_set;
    }
}

